
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class BuildConfigHandler implements ResourceHandler<BuildConfig, BuildConfigBuilder> {

  @Override
  public String getKind() {
    return BuildConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "build.openshift.io/v1";
    }

  @Override
  public BuildConfig create(OkHttpClient client, Config config, String namespace, BuildConfig item, boolean dryRun) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public BuildConfig replace(OkHttpClient client, Config config, String namespace, BuildConfig item, boolean dryRun) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public BuildConfig reload(OkHttpClient client, Config config, String namespace, BuildConfig item) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public BuildConfigBuilder edit(BuildConfig item) {
    return new BuildConfigBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, BuildConfig item, boolean dryRun) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, Watcher<BuildConfig> watcher) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, String resourceVersion, Watcher<BuildConfig> watcher) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, ListOptions options, Watcher<BuildConfig> watcher) {
  return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public BuildConfig waitUntilReady(OkHttpClient client, Config config, String namespace, BuildConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public BuildConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, BuildConfig item, Predicate<BuildConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
