
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.OpenShiftAPIServerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OpenShiftAPIServerHandler implements ResourceHandler<OpenShiftAPIServer, OpenShiftAPIServerBuilder> {

  @Override
  public String getKind() {
    return OpenShiftAPIServer.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public OpenShiftAPIServer create(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, boolean dryRun) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OpenShiftAPIServer replace(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, boolean dryRun) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OpenShiftAPIServer reload(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OpenShiftAPIServerBuilder edit(OpenShiftAPIServer item) {
    return new OpenShiftAPIServerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OpenShiftAPIServer item, boolean dryRun) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, Watcher<OpenShiftAPIServer> watcher) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, String resourceVersion, Watcher<OpenShiftAPIServer> watcher) {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, ListOptions options, Watcher<OpenShiftAPIServer> watcher) {
  return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OpenShiftAPIServer waitUntilReady(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OpenShiftAPIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, OpenShiftAPIServer item, Predicate<OpenShiftAPIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OpenShiftAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
