
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.PrometheusOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.monitoring.v1.Prometheus;
import io.fabric8.openshift.api.model.monitoring.v1.PrometheusBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PrometheusHandler implements ResourceHandler<Prometheus, PrometheusBuilder> {

  @Override
  public String getKind() {
    return Prometheus.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public Prometheus create(OkHttpClient client, Config config, String namespace, Prometheus item, boolean dryRun) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Prometheus replace(OkHttpClient client, Config config, String namespace, Prometheus item, boolean dryRun) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Prometheus reload(OkHttpClient client, Config config, String namespace, Prometheus item) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PrometheusBuilder edit(Prometheus item) {
    return new PrometheusBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Prometheus item, boolean dryRun) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, Watcher<Prometheus> watcher) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, String resourceVersion, Watcher<Prometheus> watcher) {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Prometheus item, ListOptions options, Watcher<Prometheus> watcher) {
  return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Prometheus waitUntilReady(OkHttpClient client, Config config, String namespace, Prometheus item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Prometheus waitUntilCondition(OkHttpClient client, Config config, String namespace, Prometheus item, Predicate<Prometheus> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PrometheusOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
