
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ConsoleNotificationOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleNotificationHandler implements ResourceHandler<ConsoleNotification, ConsoleNotificationBuilder> {

  @Override
  public String getKind() {
    return ConsoleNotification.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleNotification create(OkHttpClient client, Config config, String namespace, ConsoleNotification item, boolean dryRun) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleNotification replace(OkHttpClient client, Config config, String namespace, ConsoleNotification item, boolean dryRun) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleNotification reload(OkHttpClient client, Config config, String namespace, ConsoleNotification item) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleNotificationBuilder edit(ConsoleNotification item) {
    return new ConsoleNotificationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleNotification item, boolean dryRun) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, Watcher<ConsoleNotification> watcher) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, String resourceVersion, Watcher<ConsoleNotification> watcher) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleNotification item, ListOptions options, Watcher<ConsoleNotification> watcher) {
  return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleNotification waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleNotification item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleNotification waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleNotification item, Predicate<ConsoleNotification> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
