
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.ImageContentSourcePolicyOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ImageContentSourcePolicyHandler implements ResourceHandler<ImageContentSourcePolicy, ImageContentSourcePolicyBuilder> {

  @Override
  public String getKind() {
    return ImageContentSourcePolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1alpha1";
    }

  @Override
  public ImageContentSourcePolicy create(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, boolean dryRun) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ImageContentSourcePolicy replace(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, boolean dryRun) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ImageContentSourcePolicy reload(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ImageContentSourcePolicyBuilder edit(ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ImageContentSourcePolicy item, boolean dryRun) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, Watcher<ImageContentSourcePolicy> watcher) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, String resourceVersion, Watcher<ImageContentSourcePolicy> watcher) {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, ListOptions options, Watcher<ImageContentSourcePolicy> watcher) {
  return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ImageContentSourcePolicy waitUntilReady(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ImageContentSourcePolicy waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageContentSourcePolicy item, Predicate<ImageContentSourcePolicy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImageContentSourcePolicyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
