
                            

package io.fabric8.openshift.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.IngressOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.Ingress;
import io.fabric8.openshift.api.model.IngressBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IngressHandler implements ResourceHandler<Ingress, IngressBuilder> {

  @Override
  public String getKind() {
    return Ingress.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public Ingress create(OkHttpClient client, Config config, String namespace, Ingress item, boolean dryRun) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Ingress replace(OkHttpClient client, Config config, String namespace, Ingress item, boolean dryRun) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Ingress reload(OkHttpClient client, Config config, String namespace, Ingress item) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IngressBuilder edit(Ingress item) {
    return new IngressBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Ingress item, boolean dryRun) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, Watcher<Ingress> watcher) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, String resourceVersion, Watcher<Ingress> watcher) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, ListOptions options, Watcher<Ingress> watcher) {
  return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Ingress waitUntilReady(OkHttpClient client, Config config, String namespace, Ingress item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Ingress waitUntilCondition(OkHttpClient client, Config config, String namespace, Ingress item, Predicate<Ingress> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
