/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.user;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.user.IdentityOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class IdentityHandler
implements ResourceHandler<Identity, IdentityBuilder> {
    public String getKind() {
        return Identity.class.getSimpleName();
    }

    public String getApiVersion() {
        return "user.openshift.io/v1";
    }

    public Identity create(OkHttpClient client, Config config, String namespace, Identity item, boolean dryRun) {
        return (Identity)((WritableOperation)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Identity[0]);
    }

    public Identity replace(OkHttpClient client, Config config, String namespace, Identity item, boolean dryRun) {
        return (Identity)((WritableOperation)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Identity reload(OkHttpClient client, Config config, String namespace, Identity item) {
        return (Identity)((Gettable)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public IdentityBuilder edit(Identity item) {
        return new IdentityBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Identity item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, Watcher<Identity> watcher) {
        return ((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, String resourceVersion, Watcher<Identity> watcher) {
        return ((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, ListOptions options, Watcher<Identity> watcher) {
        return ((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Identity waitUntilReady(OkHttpClient client, Config config, String namespace, Identity item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Identity)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Identity waitUntilCondition(OkHttpClient client, Config config, String namespace, Identity item, Predicate<Identity> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Identity)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

