
                                                    
  

package io.fabric8.openshift.client.dsl.internal.config;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Authentication;
import io.fabric8.openshift.api.model.AuthenticationBuilder;
import io.fabric8.openshift.api.model.AuthenticationList;

import java.util.Map;
import java.util.TreeMap;


public class AuthenticationOperationsImpl extends OpenShiftOperation<Authentication, AuthenticationList, Resource<Authentication>> {

  public AuthenticationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public AuthenticationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("authentications"));
    this.type = Authentication.class;
    this.listType = AuthenticationList.class;
  }

  public AuthenticationOperationsImpl newInstance(OperationContext context) {
    return new AuthenticationOperationsImpl(context);
  }

  @Override
  public Authentication edit(Visitor... visitors) {
    return patch(new AuthenticationBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
