
                                                    
  

package io.fabric8.openshift.client.dsl.internal.config;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Scheduler;
import io.fabric8.openshift.api.model.SchedulerBuilder;
import io.fabric8.openshift.api.model.SchedulerList;

import java.util.Map;
import java.util.TreeMap;


public class SchedulerOperationsImpl extends OpenShiftOperation<Scheduler, SchedulerList, Resource<Scheduler>> {

  public SchedulerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SchedulerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("config.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("schedulers"));
    this.type = Scheduler.class;
    this.listType = SchedulerList.class;
  }

  public SchedulerOperationsImpl newInstance(OperationContext context) {
    return new SchedulerOperationsImpl(context);
  }

  @Override
  public Scheduler edit(Visitor... visitors) {
    return patch(new SchedulerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
