
                                                    
  

package io.fabric8.openshift.client.dsl.internal.console;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownload;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleCLIDownloadOperationsImpl extends OpenShiftOperation<ConsoleCLIDownload, ConsoleCLIDownloadList, Resource<ConsoleCLIDownload>> {

  public ConsoleCLIDownloadOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleCLIDownloadOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consoleclidownloads"));
    this.type = ConsoleCLIDownload.class;
    this.listType = ConsoleCLIDownloadList.class;
  }

  public ConsoleCLIDownloadOperationsImpl newInstance(OperationContext context) {
    return new ConsoleCLIDownloadOperationsImpl(context);
  }

  @Override
  public ConsoleCLIDownload edit(Visitor... visitors) {
    return patch(new ConsoleCLIDownloadBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
