
                                                    
      

package io.fabric8.openshift.client.dsl.internal.operators.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterServiceVersionOperationsImpl extends OpenShiftOperation<ClusterServiceVersion, ClusterServiceVersionList, Resource<ClusterServiceVersion>> {

  public ClusterServiceVersionOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterServiceVersionOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operators.coreos.com")
    .withApiGroupVersion("v1alpha1")
    .withPlural("clusterserviceversions"));
    this.type = ClusterServiceVersion.class;
    this.listType = ClusterServiceVersionList.class;
  }

  public ClusterServiceVersionOperationsImpl newInstance(OperationContext context) {
    return new ClusterServiceVersionOperationsImpl(context);
  }

  @Override
  public ClusterServiceVersion edit(Visitor... visitors) {
    return patch(new ClusterServiceVersionBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
