
                                                    

package io.fabric8.openshift.client.handlers.console;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleLinkOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleLinkHandler implements ResourceHandler<ConsoleLink, ConsoleLinkBuilder> {

  @Override
  public String getKind() {
    return ConsoleLink.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleLink create(OkHttpClient client, Config config, String namespace, ConsoleLink item, boolean dryRun) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleLink replace(OkHttpClient client, Config config, String namespace, ConsoleLink item, boolean dryRun) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleLink reload(OkHttpClient client, Config config, String namespace, ConsoleLink item) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleLinkBuilder edit(ConsoleLink item) {
    return new ConsoleLinkBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleLink item, boolean dryRun) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, Watcher<ConsoleLink> watcher) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, String resourceVersion, Watcher<ConsoleLink> watcher) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, ListOptions options, Watcher<ConsoleLink> watcher) {
  return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleLink waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleLink item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleLink waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleLink item, Predicate<ConsoleLink> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
