
                                                    

package io.fabric8.openshift.client.handlers.image;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.image.ImageTagOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ImageTagHandler implements ResourceHandler<ImageTag, ImageTagBuilder> {

  @Override
  public String getKind() {
    return ImageTag.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "image.openshift.io/v1";
    }

  @Override
  public ImageTag create(OkHttpClient client, Config config, String namespace, ImageTag item, boolean dryRun) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ImageTag replace(OkHttpClient client, Config config, String namespace, ImageTag item, boolean dryRun) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ImageTag reload(OkHttpClient client, Config config, String namespace, ImageTag item) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ImageTagBuilder edit(ImageTag item) {
    return new ImageTagBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ImageTag item, boolean dryRun) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, Watcher<ImageTag> watcher) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, String resourceVersion, Watcher<ImageTag> watcher) {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, ListOptions options, Watcher<ImageTag> watcher) {
  return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ImageTag waitUntilReady(OkHttpClient client, Config config, String namespace, ImageTag item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ImageTag waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageTag item, Predicate<ImageTag> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
