
                                                    

package io.fabric8.openshift.client.handlers.oauth;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OAuthAuthorizeTokenHandler implements ResourceHandler<OAuthAuthorizeToken, OAuthAuthorizeTokenBuilder> {

  @Override
  public String getKind() {
    return OAuthAuthorizeToken.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public OAuthAuthorizeToken create(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, boolean dryRun) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OAuthAuthorizeToken replace(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, boolean dryRun) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OAuthAuthorizeToken reload(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OAuthAuthorizeTokenBuilder edit(OAuthAuthorizeToken item) {
    return new OAuthAuthorizeTokenBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OAuthAuthorizeToken item, boolean dryRun) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, Watcher<OAuthAuthorizeToken> watcher) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, String resourceVersion, Watcher<OAuthAuthorizeToken> watcher) {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, ListOptions options, Watcher<OAuthAuthorizeToken> watcher) {
  return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OAuthAuthorizeToken waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OAuthAuthorizeToken waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthAuthorizeToken item, Predicate<OAuthAuthorizeToken> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OAuthAuthorizeTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
