
                                                    

package io.fabric8.openshift.client.handlers.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.operator.AuthenticationOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.Authentication;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class AuthenticationHandler implements ResourceHandler<Authentication, AuthenticationBuilder> {

  @Override
  public String getKind() {
    return Authentication.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public Authentication create(OkHttpClient client, Config config, String namespace, Authentication item, boolean dryRun) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Authentication replace(OkHttpClient client, Config config, String namespace, Authentication item, boolean dryRun) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Authentication reload(OkHttpClient client, Config config, String namespace, Authentication item) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public AuthenticationBuilder edit(Authentication item) {
    return new AuthenticationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Authentication item, boolean dryRun) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, Watcher<Authentication> watcher) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, String resourceVersion, Watcher<Authentication> watcher) {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Authentication item, ListOptions options, Watcher<Authentication> watcher) {
  return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Authentication waitUntilReady(OkHttpClient client, Config config, String namespace, Authentication item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Authentication waitUntilCondition(OkHttpClient client, Config config, String namespace, Authentication item, Predicate<Authentication> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new AuthenticationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
