
                                                    

package io.fabric8.openshift.client.handlers.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.operator.ServiceCatalogAPIServerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceCatalogAPIServerHandler implements ResourceHandler<ServiceCatalogAPIServer, ServiceCatalogAPIServerBuilder> {

  @Override
  public String getKind() {
    return ServiceCatalogAPIServer.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public ServiceCatalogAPIServer create(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, boolean dryRun) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ServiceCatalogAPIServer replace(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, boolean dryRun) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ServiceCatalogAPIServer reload(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ServiceCatalogAPIServerBuilder edit(ServiceCatalogAPIServer item) {
    return new ServiceCatalogAPIServerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ServiceCatalogAPIServer item, boolean dryRun) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, Watcher<ServiceCatalogAPIServer> watcher) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, String resourceVersion, Watcher<ServiceCatalogAPIServer> watcher) {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, ListOptions options, Watcher<ServiceCatalogAPIServer> watcher) {
  return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ServiceCatalogAPIServer waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ServiceCatalogAPIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceCatalogAPIServer item, Predicate<ServiceCatalogAPIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceCatalogAPIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
