
                                                    

package io.fabric8.openshift.client.handlers.user;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class GroupHandler implements ResourceHandler<Group, GroupBuilder> {

  @Override
  public String getKind() {
    return Group.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "user.openshift.io/v1";
    }

  @Override
  public Group create(OkHttpClient client, Config config, String namespace, Group item, boolean dryRun) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Group replace(OkHttpClient client, Config config, String namespace, Group item, boolean dryRun) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Group reload(OkHttpClient client, Config config, String namespace, Group item) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public GroupBuilder edit(Group item) {
    return new GroupBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Group item, boolean dryRun) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Group item, Watcher<Group> watcher) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Group item, String resourceVersion, Watcher<Group> watcher) {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Group item, ListOptions options, Watcher<Group> watcher) {
  return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Group waitUntilReady(OkHttpClient client, Config config, String namespace, Group item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Group waitUntilCondition(OkHttpClient client, Config config, String namespace, Group item, Predicate<Group> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GroupOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
