
                                                    

package io.fabric8.openshift.client.handlers.console;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleCLIDownloadOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownload;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleCLIDownloadHandler implements ResourceHandler<ConsoleCLIDownload, ConsoleCLIDownloadBuilder> {

  @Override
  public String getKind() {
    return ConsoleCLIDownload.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleCLIDownload create(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, boolean dryRun) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleCLIDownload replace(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, boolean dryRun) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleCLIDownload reload(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleCLIDownloadBuilder edit(ConsoleCLIDownload item) {
    return new ConsoleCLIDownloadBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleCLIDownload item, boolean dryRun) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, Watcher<ConsoleCLIDownload> watcher) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, String resourceVersion, Watcher<ConsoleCLIDownload> watcher) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, ListOptions options, Watcher<ConsoleCLIDownload> watcher) {
  return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleCLIDownload waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleCLIDownload waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item, Predicate<ConsoleCLIDownload> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
