
                                                    

package io.fabric8.openshift.client.handlers.console;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleExternalLogLinkOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleExternalLogLinkHandler implements ResourceHandler<ConsoleExternalLogLink, ConsoleExternalLogLinkBuilder> {

  @Override
  public String getKind() {
    return ConsoleExternalLogLink.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleExternalLogLink create(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, boolean dryRun) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleExternalLogLink replace(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, boolean dryRun) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleExternalLogLink reload(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleExternalLogLinkBuilder edit(ConsoleExternalLogLink item) {
    return new ConsoleExternalLogLinkBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleExternalLogLink item, boolean dryRun) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, Watcher<ConsoleExternalLogLink> watcher) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, String resourceVersion, Watcher<ConsoleExternalLogLink> watcher) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, ListOptions options, Watcher<ConsoleExternalLogLink> watcher) {
  return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleExternalLogLink waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleExternalLogLink waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item, Predicate<ConsoleExternalLogLink> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
