
                                                    
  

package io.fabric8.openshift.client.dsl.internal.autoscaling;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscaler;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterAutoscalerOperationsImpl extends OpenShiftOperation<ClusterAutoscaler, ClusterAutoscalerList, Resource<ClusterAutoscaler>> {

  public ClusterAutoscalerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterAutoscalerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("autoscaling.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("clusterautoscalers"));
    this.type = ClusterAutoscaler.class;
    this.listType = ClusterAutoscalerList.class;
  }

  public ClusterAutoscalerOperationsImpl newInstance(OperationContext context) {
    return new ClusterAutoscalerOperationsImpl(context);
  }

  @Override
  public ClusterAutoscaler edit(Visitor... visitors) {
    return patch(new ClusterAutoscalerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
