
                                                    
      

package io.fabric8.openshift.client.dsl.internal.cloudcredential;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestList;

import java.util.Map;
import java.util.TreeMap;


public class CredentialsRequestOperationsImpl extends OpenShiftOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> {

  public CredentialsRequestOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CredentialsRequestOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("cloudcredential.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("credentialsrequests"));
    this.type = CredentialsRequest.class;
    this.listType = CredentialsRequestList.class;
  }

  public CredentialsRequestOperationsImpl newInstance(OperationContext context) {
    return new CredentialsRequestOperationsImpl(context);
  }

  @Override
  public CredentialsRequest edit(Visitor... visitors) {
    return patch(new CredentialsRequestBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
