
                                                    
  

package io.fabric8.openshift.client.dsl.internal.console;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin;
import io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginBuilder;
import io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginList;

import java.util.Map;
import java.util.TreeMap;


public class ConsolePluginOperationsImpl extends OpenShiftOperation<ConsolePlugin, ConsolePluginList, Resource<ConsolePlugin>> {

  public ConsolePluginOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsolePluginOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("consoleplugins"));
    this.type = ConsolePlugin.class;
    this.listType = ConsolePluginList.class;
  }

  public ConsolePluginOperationsImpl newInstance(OperationContext context) {
    return new ConsolePluginOperationsImpl(context);
  }

  @Override
  public ConsolePlugin edit(Visitor... visitors) {
    return patch(new ConsolePluginBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
