
                                                    
  

package io.fabric8.openshift.client.dsl.internal.console;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStart;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartList;

import java.util.Map;
import java.util.TreeMap;


public class ConsoleQuickStartOperationsImpl extends OpenShiftOperation<ConsoleQuickStart, ConsoleQuickStartList, Resource<ConsoleQuickStart>> {

  public ConsoleQuickStartOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConsoleQuickStartOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("console.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("consolequickstarts"));
    this.type = ConsoleQuickStart.class;
    this.listType = ConsoleQuickStartList.class;
  }

  public ConsoleQuickStartOperationsImpl newInstance(OperationContext context) {
    return new ConsoleQuickStartOperationsImpl(context);
  }

  @Override
  public ConsoleQuickStart edit(Visitor... visitors) {
    return patch(new ConsoleQuickStartBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
