
                                                    
      

package io.fabric8.openshift.client.dsl.internal.core;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostList;

import java.util.Map;
import java.util.TreeMap;


public class BareMetalHostOperationsImpl extends OpenShiftOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> {

  public BareMetalHostOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public BareMetalHostOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("metal3.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("baremetalhosts"));
    this.type = BareMetalHost.class;
    this.listType = BareMetalHostList.class;
  }

  public BareMetalHostOperationsImpl newInstance(OperationContext context) {
    return new BareMetalHostOperationsImpl(context);
  }

  @Override
  public BareMetalHost edit(Visitor... visitors) {
    return patch(new BareMetalHostBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
