
                                                    
      

package io.fabric8.openshift.client.dsl.internal.core;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPool;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPoolBuilder;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPoolList;

import java.util.Map;
import java.util.TreeMap;


public class IPPoolOperationsImpl extends OpenShiftOperation<IPPool, IPPoolList, Resource<IPPool>> {

  public IPPoolOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public IPPoolOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("whereabouts.cni.cncf.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("ippools"));
    this.type = IPPool.class;
    this.listType = IPPoolList.class;
  }

  public IPPoolOperationsImpl newInstance(OperationContext context) {
    return new IPPoolOperationsImpl(context);
  }

  @Override
  public IPPool edit(Visitor... visitors) {
    return patch(new IPPoolBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
