
                                                    
  

package io.fabric8.openshift.client.dsl.internal.helm;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryBuilder;
import io.fabric8.openshift.api.model.HelmChartRepositoryList;

import java.util.Map;
import java.util.TreeMap;


public class HelmChartRepositoryOperationsImpl extends OpenShiftOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> {

  public HelmChartRepositoryOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public HelmChartRepositoryOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("helm.openshift.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("helmchartrepositories"));
    this.type = HelmChartRepository.class;
    this.listType = HelmChartRepositoryList.class;
  }

  public HelmChartRepositoryOperationsImpl newInstance(OperationContext context) {
    return new HelmChartRepositoryOperationsImpl(context);
  }

  @Override
  public HelmChartRepository edit(Visitor... visitors) {
    return patch(new HelmChartRepositoryBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
