
                                                    
      

package io.fabric8.openshift.client.dsl.internal.machine;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machine.v1beta1.Machine;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineList;

import java.util.Map;
import java.util.TreeMap;


public class MachineOperationsImpl extends OpenShiftOperation<Machine, MachineList, Resource<Machine>> {

  public MachineOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public MachineOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("machine.openshift.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("machines"));
    this.type = Machine.class;
    this.listType = MachineList.class;
  }

  public MachineOperationsImpl newInstance(OperationContext context) {
    return new MachineOperationsImpl(context);
  }

  @Override
  public Machine edit(Visitor... visitors) {
    return patch(new MachineBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
