
                                                    
      

package io.fabric8.openshift.client.dsl.internal.machine;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machine.v1beta1.MachineSet;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetList;

import java.util.Map;
import java.util.TreeMap;


public class MachineSetOperationsImpl extends OpenShiftOperation<MachineSet, MachineSetList, Resource<MachineSet>> {

  public MachineSetOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public MachineSetOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("machine.openshift.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("machinesets"));
    this.type = MachineSet.class;
    this.listType = MachineSetList.class;
  }

  public MachineSetOperationsImpl newInstance(OperationContext context) {
    return new MachineSetOperationsImpl(context);
  }

  @Override
  public MachineSet edit(Visitor... visitors) {
    return patch(new MachineSetBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
