
                                                    
  

package io.fabric8.openshift.client.dsl.internal.machineconfiguration;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.KubeletConfigList;

import java.util.Map;
import java.util.TreeMap;


public class KubeletConfigOperationsImpl extends OpenShiftOperation<KubeletConfig, KubeletConfigList, Resource<KubeletConfig>> {

  public KubeletConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KubeletConfigOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("machineconfiguration.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("kubeletconfigs"));
    this.type = KubeletConfig.class;
    this.listType = KubeletConfigList.class;
  }

  public KubeletConfigOperationsImpl newInstance(OperationContext context) {
    return new KubeletConfigOperationsImpl(context);
  }

  @Override
  public KubeletConfig edit(Visitor... visitors) {
    return patch(new KubeletConfigBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
