
                                                    
      

package io.fabric8.openshift.client.dsl.internal.monitoring.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1alpha1.AlertmanagerConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AlertmanagerConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.AlertmanagerConfigList;

import java.util.Map;
import java.util.TreeMap;


public class AlertmanagerConfigOperationsImpl extends OpenShiftOperation<AlertmanagerConfig, AlertmanagerConfigList, Resource<AlertmanagerConfig>> {

  public AlertmanagerConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public AlertmanagerConfigOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1alpha1")
    .withPlural("alertmanagerconfigs"));
    this.type = AlertmanagerConfig.class;
    this.listType = AlertmanagerConfigList.class;
  }

  public AlertmanagerConfigOperationsImpl newInstance(OperationContext context) {
    return new AlertmanagerConfigOperationsImpl(context);
  }

  @Override
  public AlertmanagerConfig edit(Visitor... visitors) {
    return patch(new AlertmanagerConfigBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
