
                                                    
      

package io.fabric8.openshift.client.dsl.internal.monitoring.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.monitoring.v1.Probe;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeList;

import java.util.Map;
import java.util.TreeMap;


public class ProbeOperationsImpl extends OpenShiftOperation<Probe, ProbeList, Resource<Probe>> {

  public ProbeOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ProbeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("monitoring.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("probes"));
    this.type = Probe.class;
    this.listType = ProbeList.class;
  }

  public ProbeOperationsImpl newInstance(OperationContext context) {
    return new ProbeOperationsImpl(context);
  }

  @Override
  public Probe edit(Visitor... visitors) {
    return patch(new ProbeBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
