
                                                    
  

package io.fabric8.openshift.client.dsl.internal.operators.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1.Operator;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorList;

import java.util.Map;
import java.util.TreeMap;


public class OperatorOperationsImpl extends OpenShiftOperation<Operator, OperatorList, Resource<Operator>> {

  public OperatorOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OperatorOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operators.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("operators"));
    this.type = Operator.class;
    this.listType = OperatorList.class;
  }

  public OperatorOperationsImpl newInstance(OperationContext context) {
    return new OperatorOperationsImpl(context);
  }

  @Override
  public Operator edit(Visitor... visitors) {
    return patch(new OperatorBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
