
                                                    
      

package io.fabric8.openshift.client.dsl.internal.packages.operators.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifest;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifestBuilder;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifestList;

import java.util.Map;
import java.util.TreeMap;


public class PackageManifestOperationsImpl extends OpenShiftOperation<PackageManifest, PackageManifestList, Resource<PackageManifest>> {

  public PackageManifestOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PackageManifestOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("packages.operators.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("packagemanifests"));
    this.type = PackageManifest.class;
    this.listType = PackageManifestList.class;
  }

  public PackageManifestOperationsImpl newInstance(OperationContext context) {
    return new PackageManifestOperationsImpl(context);
  }

  @Override
  public PackageManifest edit(Visitor... visitors) {
    return patch(new PackageManifestBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
