
                                                    
  

package io.fabric8.openshift.client.dsl.internal.template;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceList;

import java.util.Map;
import java.util.TreeMap;


public class BrokerTemplateInstanceOperationsImpl extends OpenShiftOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> {

  public BrokerTemplateInstanceOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public BrokerTemplateInstanceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("template.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("brokertemplateinstances"));
    this.type = BrokerTemplateInstance.class;
    this.listType = BrokerTemplateInstanceList.class;
  }

  public BrokerTemplateInstanceOperationsImpl newInstance(OperationContext context) {
    return new BrokerTemplateInstanceOperationsImpl(context);
  }

  @Override
  public BrokerTemplateInstance edit(Visitor... visitors) {
    return patch(new BrokerTemplateInstanceBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
