
                                                    

package io.fabric8.openshift.client.handlers.authorization;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleBindingRestrictionOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class RoleBindingRestrictionHandler implements ResourceHandler<RoleBindingRestriction, RoleBindingRestrictionBuilder> {

  @Override
  public String getKind() {
    return RoleBindingRestriction.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authorization.openshift.io/v1";
    }

  @Override
  public RoleBindingRestriction create(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, boolean dryRun) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public RoleBindingRestriction replace(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, boolean dryRun) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public RoleBindingRestriction reload(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public RoleBindingRestrictionBuilder edit(RoleBindingRestriction item) {
    return new RoleBindingRestrictionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, RoleBindingRestriction item, boolean dryRun) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, Watcher<RoleBindingRestriction> watcher) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, String resourceVersion, Watcher<RoleBindingRestriction> watcher) {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, ListOptions options, Watcher<RoleBindingRestriction> watcher) {
  return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public RoleBindingRestriction waitUntilReady(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public RoleBindingRestriction waitUntilCondition(OkHttpClient client, Config config, String namespace, RoleBindingRestriction item, Predicate<RoleBindingRestriction> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RoleBindingRestrictionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
