
                                                    

package io.fabric8.openshift.client.handlers.autoscaling;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.autoscaling.MachineAutoscalerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscaler;
import io.fabric8.openshift.api.model.clusterautoscaling.v1beta1.MachineAutoscalerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MachineAutoscalerHandler implements ResourceHandler<MachineAutoscaler, MachineAutoscalerBuilder> {

  @Override
  public String getKind() {
    return MachineAutoscaler.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "autoscaling.openshift.io/v1beta1";
    }

  @Override
  public MachineAutoscaler create(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, boolean dryRun) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public MachineAutoscaler replace(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, boolean dryRun) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public MachineAutoscaler reload(OkHttpClient client, Config config, String namespace, MachineAutoscaler item) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public MachineAutoscalerBuilder edit(MachineAutoscaler item) {
    return new MachineAutoscalerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineAutoscaler item, boolean dryRun) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, Watcher<MachineAutoscaler> watcher) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, String resourceVersion, Watcher<MachineAutoscaler> watcher) {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, ListOptions options, Watcher<MachineAutoscaler> watcher) {
  return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public MachineAutoscaler waitUntilReady(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public MachineAutoscaler waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineAutoscaler item, Predicate<MachineAutoscaler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineAutoscalerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
