
                                                    

package io.fabric8.openshift.client.handlers.console;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.console.ConsolePluginOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin;
import io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsolePluginHandler implements ResourceHandler<ConsolePlugin, ConsolePluginBuilder> {

  @Override
  public String getKind() {
    return ConsolePlugin.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1alpha1";
    }

  @Override
  public ConsolePlugin create(OkHttpClient client, Config config, String namespace, ConsolePlugin item, boolean dryRun) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsolePlugin replace(OkHttpClient client, Config config, String namespace, ConsolePlugin item, boolean dryRun) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsolePlugin reload(OkHttpClient client, Config config, String namespace, ConsolePlugin item) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsolePluginBuilder edit(ConsolePlugin item) {
    return new ConsolePluginBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsolePlugin item, boolean dryRun) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsolePlugin item, Watcher<ConsolePlugin> watcher) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsolePlugin item, String resourceVersion, Watcher<ConsolePlugin> watcher) {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsolePlugin item, ListOptions options, Watcher<ConsolePlugin> watcher) {
  return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsolePlugin waitUntilReady(OkHttpClient client, Config config, String namespace, ConsolePlugin item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsolePlugin waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsolePlugin item, Predicate<ConsolePlugin> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsolePluginOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
