
                                                    

package io.fabric8.openshift.client.handlers.console;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleQuickStartOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStart;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleQuickStartHandler implements ResourceHandler<ConsoleQuickStart, ConsoleQuickStartBuilder> {

  @Override
  public String getKind() {
    return ConsoleQuickStart.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleQuickStart create(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, boolean dryRun) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ConsoleQuickStart replace(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, boolean dryRun) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ConsoleQuickStart reload(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleQuickStartBuilder edit(ConsoleQuickStart item) {
    return new ConsoleQuickStartBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleQuickStart item, boolean dryRun) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, Watcher<ConsoleQuickStart> watcher) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, String resourceVersion, Watcher<ConsoleQuickStart> watcher) {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, ListOptions options, Watcher<ConsoleQuickStart> watcher) {
  return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ConsoleQuickStart waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ConsoleQuickStart waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleQuickStart item, Predicate<ConsoleQuickStart> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleQuickStartOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
