
                                                    

package io.fabric8.openshift.client.handlers.controlplane.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.controlplane.operator.PodNetworkConnectivityCheckOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PodNetworkConnectivityCheckHandler implements ResourceHandler<PodNetworkConnectivityCheck, PodNetworkConnectivityCheckBuilder> {

  @Override
  public String getKind() {
    return PodNetworkConnectivityCheck.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "controlplane.operator.openshift.io/v1alpha1";
    }

  @Override
  public PodNetworkConnectivityCheck create(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, boolean dryRun) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PodNetworkConnectivityCheck replace(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, boolean dryRun) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PodNetworkConnectivityCheck reload(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PodNetworkConnectivityCheckBuilder edit(PodNetworkConnectivityCheck item) {
    return new PodNetworkConnectivityCheckBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PodNetworkConnectivityCheck item, boolean dryRun) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, Watcher<PodNetworkConnectivityCheck> watcher) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, String resourceVersion, Watcher<PodNetworkConnectivityCheck> watcher) {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, ListOptions options, Watcher<PodNetworkConnectivityCheck> watcher) {
  return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public PodNetworkConnectivityCheck waitUntilReady(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PodNetworkConnectivityCheck waitUntilCondition(OkHttpClient client, Config config, String namespace, PodNetworkConnectivityCheck item, Predicate<PodNetworkConnectivityCheck> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PodNetworkConnectivityCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
