
                                                    

package io.fabric8.openshift.client.handlers.core;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.core.BareMetalHostOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class BareMetalHostHandler implements ResourceHandler<BareMetalHost, BareMetalHostBuilder> {

  @Override
  public String getKind() {
    return BareMetalHost.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "metal3.io/v1alpha1";
    }

  @Override
  public BareMetalHost create(OkHttpClient client, Config config, String namespace, BareMetalHost item, boolean dryRun) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public BareMetalHost replace(OkHttpClient client, Config config, String namespace, BareMetalHost item, boolean dryRun) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public BareMetalHost reload(OkHttpClient client, Config config, String namespace, BareMetalHost item) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public BareMetalHostBuilder edit(BareMetalHost item) {
    return new BareMetalHostBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, BareMetalHost item, boolean dryRun) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BareMetalHost item, Watcher<BareMetalHost> watcher) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BareMetalHost item, String resourceVersion, Watcher<BareMetalHost> watcher) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BareMetalHost item, ListOptions options, Watcher<BareMetalHost> watcher) {
  return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public BareMetalHost waitUntilReady(OkHttpClient client, Config config, String namespace, BareMetalHost item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public BareMetalHost waitUntilCondition(OkHttpClient client, Config config, String namespace, BareMetalHost item, Predicate<BareMetalHost> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
