
                                                    

package io.fabric8.openshift.client.handlers.core;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.core.IPPoolOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPool;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPoolBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IPPoolHandler implements ResourceHandler<IPPool, IPPoolBuilder> {

  @Override
  public String getKind() {
    return IPPool.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "whereabouts.cni.cncf.io/v1alpha1";
    }

  @Override
  public IPPool create(OkHttpClient client, Config config, String namespace, IPPool item, boolean dryRun) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public IPPool replace(OkHttpClient client, Config config, String namespace, IPPool item, boolean dryRun) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public IPPool reload(OkHttpClient client, Config config, String namespace, IPPool item) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IPPoolBuilder edit(IPPool item) {
    return new IPPoolBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, IPPool item, boolean dryRun) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, Watcher<IPPool> watcher) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, String resourceVersion, Watcher<IPPool> watcher) {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, ListOptions options, Watcher<IPPool> watcher) {
  return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public IPPool waitUntilReady(OkHttpClient client, Config config, String namespace, IPPool item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public IPPool waitUntilCondition(OkHttpClient client, Config config, String namespace, IPPool item, Predicate<IPPool> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
