
                                                    

package io.fabric8.openshift.client.handlers.core;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class NetworkAttachmentDefinitionHandler implements ResourceHandler<NetworkAttachmentDefinition, NetworkAttachmentDefinitionBuilder> {

  @Override
  public String getKind() {
    return NetworkAttachmentDefinition.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "k8s.cni.cncf.io/v1";
    }

  @Override
  public NetworkAttachmentDefinition create(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, boolean dryRun) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public NetworkAttachmentDefinition replace(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, boolean dryRun) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public NetworkAttachmentDefinition reload(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public NetworkAttachmentDefinitionBuilder edit(NetworkAttachmentDefinition item) {
    return new NetworkAttachmentDefinitionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, NetworkAttachmentDefinition item, boolean dryRun) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, Watcher<NetworkAttachmentDefinition> watcher) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, String resourceVersion, Watcher<NetworkAttachmentDefinition> watcher) {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, ListOptions options, Watcher<NetworkAttachmentDefinition> watcher) {
  return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public NetworkAttachmentDefinition waitUntilReady(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public NetworkAttachmentDefinition waitUntilCondition(OkHttpClient client, Config config, String namespace, NetworkAttachmentDefinition item, Predicate<NetworkAttachmentDefinition> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NetworkAttachmentDefinitionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
