
                                                    

package io.fabric8.openshift.client.handlers.core;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.core.StorageStateOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageState;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class StorageStateHandler implements ResourceHandler<StorageState, StorageStateBuilder> {

  @Override
  public String getKind() {
    return StorageState.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "migration.k8s.io/v1alpha1";
    }

  @Override
  public StorageState create(OkHttpClient client, Config config, String namespace, StorageState item, boolean dryRun) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public StorageState replace(OkHttpClient client, Config config, String namespace, StorageState item, boolean dryRun) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public StorageState reload(OkHttpClient client, Config config, String namespace, StorageState item) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public StorageStateBuilder edit(StorageState item) {
    return new StorageStateBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, StorageState item, boolean dryRun) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, Watcher<StorageState> watcher) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, String resourceVersion, Watcher<StorageState> watcher) {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageState item, ListOptions options, Watcher<StorageState> watcher) {
  return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public StorageState waitUntilReady(OkHttpClient client, Config config, String namespace, StorageState item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public StorageState waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageState item, Predicate<StorageState> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StorageStateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
