
                                                    

package io.fabric8.openshift.client.handlers.core;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.core.StorageVersionMigrationOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigration;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigrationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class StorageVersionMigrationHandler implements ResourceHandler<StorageVersionMigration, StorageVersionMigrationBuilder> {

  @Override
  public String getKind() {
    return StorageVersionMigration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "migration.k8s.io/v1alpha1";
    }

  @Override
  public StorageVersionMigration create(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, boolean dryRun) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public StorageVersionMigration replace(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, boolean dryRun) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public StorageVersionMigration reload(OkHttpClient client, Config config, String namespace, StorageVersionMigration item) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public StorageVersionMigrationBuilder edit(StorageVersionMigration item) {
    return new StorageVersionMigrationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, StorageVersionMigration item, boolean dryRun) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, Watcher<StorageVersionMigration> watcher) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, String resourceVersion, Watcher<StorageVersionMigration> watcher) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, ListOptions options, Watcher<StorageVersionMigration> watcher) {
  return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public StorageVersionMigration waitUntilReady(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public StorageVersionMigration waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, Predicate<StorageVersionMigration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
