
                                                    

package io.fabric8.openshift.client.handlers.helm;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.helm.HelmChartRepositoryOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class HelmChartRepositoryHandler implements ResourceHandler<HelmChartRepository, HelmChartRepositoryBuilder> {

  @Override
  public String getKind() {
    return HelmChartRepository.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "helm.openshift.io/v1beta1";
    }

  @Override
  public HelmChartRepository create(OkHttpClient client, Config config, String namespace, HelmChartRepository item, boolean dryRun) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public HelmChartRepository replace(OkHttpClient client, Config config, String namespace, HelmChartRepository item, boolean dryRun) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public HelmChartRepository reload(OkHttpClient client, Config config, String namespace, HelmChartRepository item) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public HelmChartRepositoryBuilder edit(HelmChartRepository item) {
    return new HelmChartRepositoryBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, HelmChartRepository item, boolean dryRun) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HelmChartRepository item, Watcher<HelmChartRepository> watcher) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HelmChartRepository item, String resourceVersion, Watcher<HelmChartRepository> watcher) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HelmChartRepository item, ListOptions options, Watcher<HelmChartRepository> watcher) {
  return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public HelmChartRepository waitUntilReady(OkHttpClient client, Config config, String namespace, HelmChartRepository item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public HelmChartRepository waitUntilCondition(OkHttpClient client, Config config, String namespace, HelmChartRepository item, Predicate<HelmChartRepository> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
