
                                                    

package io.fabric8.openshift.client.handlers.machine;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.machine.MachineOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.machine.v1beta1.Machine;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MachineHandler implements ResourceHandler<Machine, MachineBuilder> {

  @Override
  public String getKind() {
    return Machine.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machine.openshift.io/v1beta1";
    }

  @Override
  public Machine create(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Machine replace(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Machine reload(OkHttpClient client, Config config, String namespace, Machine item) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public MachineBuilder edit(Machine item) {
    return new MachineBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Machine item, boolean dryRun) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, Watcher<Machine> watcher) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, String resourceVersion, Watcher<Machine> watcher) {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, ListOptions options, Watcher<Machine> watcher) {
  return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Machine waitUntilReady(OkHttpClient client, Config config, String namespace, Machine item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Machine waitUntilCondition(OkHttpClient client, Config config, String namespace, Machine item, Predicate<Machine> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
