
                                                    

package io.fabric8.openshift.client.handlers.machine;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.machine.MachineHealthCheckOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheck;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MachineHealthCheckHandler implements ResourceHandler<MachineHealthCheck, MachineHealthCheckBuilder> {

  @Override
  public String getKind() {
    return MachineHealthCheck.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machine.openshift.io/v1beta1";
    }

  @Override
  public MachineHealthCheck create(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, boolean dryRun) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public MachineHealthCheck replace(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, boolean dryRun) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public MachineHealthCheck reload(OkHttpClient client, Config config, String namespace, MachineHealthCheck item) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public MachineHealthCheckBuilder edit(MachineHealthCheck item) {
    return new MachineHealthCheckBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineHealthCheck item, boolean dryRun) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, Watcher<MachineHealthCheck> watcher) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, String resourceVersion, Watcher<MachineHealthCheck> watcher) {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, ListOptions options, Watcher<MachineHealthCheck> watcher) {
  return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public MachineHealthCheck waitUntilReady(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public MachineHealthCheck waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineHealthCheck item, Predicate<MachineHealthCheck> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineHealthCheckOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
