
                                                    

package io.fabric8.openshift.client.handlers.machineconfiguration;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.ContainerRuntimeConfigOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.ContainerRuntimeConfigBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ContainerRuntimeConfigHandler implements ResourceHandler<ContainerRuntimeConfig, ContainerRuntimeConfigBuilder> {

  @Override
  public String getKind() {
    return ContainerRuntimeConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machineconfiguration.openshift.io/v1";
    }

  @Override
  public ContainerRuntimeConfig create(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, boolean dryRun) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ContainerRuntimeConfig replace(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, boolean dryRun) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ContainerRuntimeConfig reload(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ContainerRuntimeConfigBuilder edit(ContainerRuntimeConfig item) {
    return new ContainerRuntimeConfigBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ContainerRuntimeConfig item, boolean dryRun) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, Watcher<ContainerRuntimeConfig> watcher) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, String resourceVersion, Watcher<ContainerRuntimeConfig> watcher) {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, ListOptions options, Watcher<ContainerRuntimeConfig> watcher) {
  return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ContainerRuntimeConfig waitUntilReady(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ContainerRuntimeConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, ContainerRuntimeConfig item, Predicate<ContainerRuntimeConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerRuntimeConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
