
                                                    

package io.fabric8.openshift.client.handlers.machineconfiguration;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MachineConfigHandler implements ResourceHandler<MachineConfig, MachineConfigBuilder> {

  @Override
  public String getKind() {
    return MachineConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machineconfiguration.openshift.io/v1";
    }

  @Override
  public MachineConfig create(OkHttpClient client, Config config, String namespace, MachineConfig item, boolean dryRun) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public MachineConfig replace(OkHttpClient client, Config config, String namespace, MachineConfig item, boolean dryRun) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public MachineConfig reload(OkHttpClient client, Config config, String namespace, MachineConfig item) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public MachineConfigBuilder edit(MachineConfig item) {
    return new MachineConfigBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineConfig item, boolean dryRun) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, Watcher<MachineConfig> watcher) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, String resourceVersion, Watcher<MachineConfig> watcher) {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfig item, ListOptions options, Watcher<MachineConfig> watcher) {
  return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public MachineConfig waitUntilReady(OkHttpClient client, Config config, String namespace, MachineConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public MachineConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineConfig item, Predicate<MachineConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
