
                                                    

package io.fabric8.openshift.client.handlers.machineconfiguration;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.machineconfiguration.MachineConfigPoolOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPool;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigPoolBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MachineConfigPoolHandler implements ResourceHandler<MachineConfigPool, MachineConfigPoolBuilder> {

  @Override
  public String getKind() {
    return MachineConfigPool.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "machineconfiguration.openshift.io/v1";
    }

  @Override
  public MachineConfigPool create(OkHttpClient client, Config config, String namespace, MachineConfigPool item, boolean dryRun) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public MachineConfigPool replace(OkHttpClient client, Config config, String namespace, MachineConfigPool item, boolean dryRun) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public MachineConfigPool reload(OkHttpClient client, Config config, String namespace, MachineConfigPool item) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public MachineConfigPoolBuilder edit(MachineConfigPool item) {
    return new MachineConfigPoolBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, MachineConfigPool item, boolean dryRun) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, Watcher<MachineConfigPool> watcher) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, String resourceVersion, Watcher<MachineConfigPool> watcher) {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, MachineConfigPool item, ListOptions options, Watcher<MachineConfigPool> watcher) {
  return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public MachineConfigPool waitUntilReady(OkHttpClient client, Config config, String namespace, MachineConfigPool item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public MachineConfigPool waitUntilCondition(OkHttpClient client, Config config, String namespace, MachineConfigPool item, Predicate<MachineConfigPool> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new MachineConfigPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
